function [resid, struct_param, endo_ss, phis] = calibrate_ss_resid_fracking(theta_n, exo_param, MS_f)
% This function computes the residuals given a guess of theta_n, and a
% calibration of G_f given MS_f


beta    = exo_param.beta;
epsilon = exo_param.epsilon;
alpha   = exo_param.alpha;
eta     = exo_param.eta;
psi     = exo_param.psi;
lambda  = exo_param.lambda;
nu      = exo_param.nu;
delta   = exo_param.delta;
gamma   = exo_param.gamma;
G_n     = exo_param.G_n;
G_o     = exo_param.G_o;
eta_f   = exo_param.eta_f;
lambda_f= exo_param.lambda_f;
s_o     = exo_param.s_o;
varphi  = exo_param.varphi;
xi      = exo_param.xi;


r       = 1/beta - (1-delta);
beta_til= beta;

% Getting non-OPEC allocations.
mu_1_n  = beta/(1-beta) * psi * (eta-1) * theta_n^eta;
p       = mu_1_n + eta*psi*theta_n^(eta-1);
mu_2_n  = lambda/(1-beta*(1-lambda)) * mu_1_n;
I_n     = (xi * G_n^(1-xi) * mu_2_n)^(1/(1-xi));
X_n     = I_n^xi * G_n^(1-xi)/lambda;
F_n     = lambda*X_n/theta_n;

% Getting aggregate allocations
O2Y     = (s_o/p)^epsilon;
VA2Y    = ((1-s_o*O2Y^((epsilon-1)/epsilon))/(1-s_o))^(epsilon/(epsilon-1));
K2Y     = 1/r * alpha * (1-s_o) * VA2Y^((epsilon-1)/epsilon);
L2Y     = (VA2Y * K2Y^(-alpha))^(1/(1-alpha));
w       = r * (1-alpha)/alpha * K2Y/L2Y;
L       = (w/varphi)^(1/nu);
Y       = L/L2Y;
K       = K2Y * Y;
o       = O2Y * Y;
VA      = VA2Y * Y;

% Fracking: Recovering psi_f and calibrating G_f.
ac_f    = psi * theta_n^(eta-1);
theta_f = 1/((eta_f-1)*beta*ac_f) * ((1-beta)*p - (1-beta)*eta_f*ac_f);
psi_f   = ac_f / (theta_f^(eta_f-1));

mu_1_f  = beta/(1-beta) * psi_f * (eta_f-1) * theta_f^eta_f;
mu_2_f  = lambda_f/(1-beta*(1-lambda_f)) * mu_1_f;
I2G_f   = (xi*mu_2_f)^(1/(1-xi));

prod_f  = MS_f * o;
F_f     = prod_f/theta_f;
X_f     = prod_f/lambda_f;
G_f     = lambda_f * X_f / (I2G_f^xi);
I_f     = I2G_f * G_f;


% Move towards OPEC quantities
q_o     = o - F_n*theta_n - F_f*theta_f;
X_o     = q_o/lambda;
I_o     = (lambda*X_o*G_o^(xi-1))^(1/xi);
theta_o = (I_o^(1-xi)*G_o^(xi-1)/xi*(1-beta*(1-lambda))/lambda*(1-beta)/beta*1/((eta-1)*psi))^(1/eta);
F_o     = q_o/theta_o;

% Get consumption from resource constraint
C       = Y - delta * K - I_n - I_o - I_f - psi*theta_n^eta*F_n - psi_f*theta_f^eta_f*F_f - psi*theta_o^eta*F_o;

% Now we want to get Lagrange multipliers and arrive at two residual equations
%   First get other variables that enter the function
I2G_n   = I_n/G_n;

f_target = @(x) res_RC(x, beta, psi, eta, theta_o, p, lambda, ...
     theta_n, xi, I2G_n, I_n, mu_2_n, F_n, F_o, epsilon, o, Y, s_o, r, K, w, ...
     alpha, nu, L, mu_1_n, varphi, gamma, I_o, C, ...
     I_f, I2G_f, F_f, theta_f, mu_1_f, mu_2_f, psi_f, eta_f, lambda_f);

evalc('[phi_RC, ~, flag] = fsolve(f_target, -1);');

% % % Use phi_RC: % % %
mu_1_o  = beta/(1-beta) * psi* (eta-1)*theta_o^(eta) *(1-phi_RC);
phi_O   = p - mu_1_o - eta*psi*theta_o^(eta-1) * (1-phi_RC);
mu_2_o  = lambda/(1-beta*(1-lambda)) * mu_1_o;

% Non-fracking
phi_mu_1    = beta/(1-beta*(1-theta_n)) * (theta_n*phi_O -psi*theta_n^(eta)*phi_RC);
phi_mu_2    = lambda/(1-beta*(1-lambda)) * phi_mu_1;
phi_I       = (phi_mu_2 - 1/xi * I2G_n^(1-xi)*phi_RC)/((1-xi)*I_n^(-1)*mu_2_n);
phi_theta   = F_n * (phi_O - eta*psi*theta_n^(eta-1)*phi_RC - phi_mu_1) / (eta*(eta-1)*psi*theta_n^(eta-2));
phi_X       = xi/lambda * I2G_n^(xi-1) * phi_I;
phi_F       = (lambda*phi_X - phi_theta)/theta_n;

% Fracking
phi_mu_1_f    = beta/(1-beta*(1-theta_f)) * (theta_f*phi_O -psi_f*theta_f^(eta_f)*phi_RC);
phi_mu_2_f    = lambda_f/(1-beta*(1-lambda_f)) * phi_mu_1_f;
phi_I_f       = (phi_mu_2_f - 1/xi * I2G_f^(1-xi)*phi_RC)/((1-xi)*I_f^(-1)*mu_2_f);
phi_theta_f   = F_f * (phi_O - eta_f*psi_f*theta_f^(eta_f-1)*phi_RC - phi_mu_1_f) / (eta_f*(eta_f-1)*psi_f*theta_f^(eta_f-2));
phi_X_f       = xi/lambda_f * I2G_f^(xi-1) * phi_I_f;
phi_F_f       = (lambda_f*phi_X_f - phi_theta_f)/theta_f;


phi_P       = theta_o * F_o - theta_n*phi_F - phi_theta - theta_f*phi_F_f - phi_theta_f;
phi_Y       = (1/epsilon *Y^(1/epsilon)*s_o*o^(-1/epsilon-1) * phi_P - phi_O)/(Y^(1/epsilon)*s_o*o^(-1/epsilon));

% Finding phi_r and phi_w
wphi_rphi = (phi_Y + phi_RC)*epsilon*Y - p * phi_P;
phi_r     = ((phi_Y + phi_RC)*r*K + (epsilon-1)/epsilon*alpha*wphi_rphi)/r;
phi_w     = (wphi_rphi - r * phi_r)/w;
phi_K     = phi_r;
phi_L     = w * phi_w * nu/L;
phi_beta  = -((p*theta_n + (1-theta_n)*mu_1_n - psi*theta_n^(eta))*phi_F + (1-lambda)*mu_2_n*phi_X ...
              + (p*theta_f + (1-theta_f)*mu_1_f - psi_f*theta_f^(eta_f))*phi_F_f + (1-lambda_f)*mu_2_f*phi_X_f...
              - 1/beta*phi_K)/beta;

Mutil   = C - varphi * L^(1+nu)/(1+nu);

 
resid    = -w * phi_RC + phi_L * ((1-((epsilon-1)/epsilon)*(1-alpha))/nu+1) ...
        - (epsilon-1)/epsilon*(1-alpha)*r/L*phi_r - w*phi_Y;


st_param_names = {'beta', 'epsilon', 'alpha', 'eta', 'psi', 'lambda', 'nu', ...
                  'delta', 'gamma', 'xi', 'G_n', 'G_o', 'G_f', 's_o', 'varphi', ...
                  'psi_f', 'eta_f', 'lambda_f'};
for i = 1:length(st_param_names)
    eval(['struct_param.' st_param_names{i} ' = ' st_param_names{i} ';']);
end


endo_ss_names = {'p' 'I_o' 'I_n' 'I_f' 'F_o' 'F_n' 'F_f' 'X_o' 'X_n' 'X_f' ...
                 'theta_o' 'theta_n' 'theta_f' 'VA' 'mu_1_n' 'mu_2_n' ...
                 'mu_1_o' 'mu_2_o' 'mu_1_f' 'mu_2_f' 'o' 'Y' 'K' 'L' ...
                 'C' 'r' 'w' 'beta_til'};
for i = 1:length(endo_ss_names)
    eval(['endo_ss.' endo_ss_names{i} ' = ' endo_ss_names{i} ';']);
end

phi_names = {'mu_1' 'mu_2' 'I' 'theta' 'X' 'F' ...
             'mu_1_f' 'mu_2_f' 'I_f' 'theta_f' 'X_f' 'F_f' ...
             'P' 'Y' 'r' 'O' 'w' 'K' 'L' 'beta' 'RC'};
for i = 1:length(phi_names)
    eval(['phis.' phi_names{i} ' = phi_' phi_names{i} ';']);
end


% keyboard

function resid_phi_RC = res_RC(phi_RC, beta, psi, eta, theta_o, p, lambda, ...
     theta_n, xi, I2G_n, I_n, mu_2_n, F_n, F_o, epsilon, o, Y, s_o, r, K, w, ...
     alpha, nu, L, mu_1_n, varphi, gamma, I_o, C, ...
     I_f, I2G_f, F_f, theta_f, mu_1_f, mu_2_f, psi_f, eta_f, lambda_f)

mu_1_o  = beta/(1-beta) * psi* (eta-1)*theta_o^(eta) *(1-phi_RC);
phi_O   = p - mu_1_o - eta*psi*theta_o^(eta-1) * (1-phi_RC);
mu_2_o  = lambda/(1-beta*(1-lambda)) * mu_1_o;

% Non-fracking
phi_mu_1    = beta/(1-beta*(1-theta_n)) * (theta_n*phi_O -psi*theta_n^(eta)*phi_RC);
phi_mu_2    = lambda/(1-beta*(1-lambda)) * phi_mu_1;
phi_I       = (phi_mu_2 - 1/xi * I2G_n^(1-xi)*phi_RC)/((1-xi)*I_n^(-1)*mu_2_n);
phi_theta   = F_n * (phi_O - eta*psi*theta_n^(eta-1)*phi_RC - phi_mu_1) / (eta*(eta-1)*psi*theta_n^(eta-2));
phi_X       = xi/lambda * I2G_n^(xi-1) * phi_I;
phi_F       = (lambda*phi_X - phi_theta)/theta_n;

% Fracking
phi_mu_1_f    = beta/(1-beta*(1-theta_f)) * (theta_f*phi_O -psi_f*theta_f^(eta_f)*phi_RC);
phi_mu_2_f    = lambda_f/(1-beta*(1-lambda_f)) * phi_mu_1_f;
phi_I_f       = (phi_mu_2_f - 1/xi * I2G_f^(1-xi)*phi_RC)/((1-xi)*I_f^(-1)*mu_2_f);
phi_theta_f   = F_f * (phi_O - eta_f*psi_f*theta_f^(eta_f-1)*phi_RC - phi_mu_1_f) / (eta_f*(eta_f-1)*psi_f*theta_f^(eta_f-2));
phi_X_f       = xi/lambda_f * I2G_f^(xi-1) * phi_I_f;
phi_F_f       = (lambda_f*phi_X_f - phi_theta_f)/theta_f;


phi_P       = theta_o * F_o - theta_n*phi_F - phi_theta - theta_f*phi_F_f - phi_theta_f;
phi_Y       = (1/epsilon *Y^(1/epsilon)*s_o*o^(-1/epsilon-1) * phi_P - phi_O)/(Y^(1/epsilon)*s_o*o^(-1/epsilon));

% Finding phi_r and phi_w
%  Can get w phi_w + r phi_r:
wphi_rphi = (phi_Y + phi_RC)*epsilon*Y - p * phi_P;
phi_r     = ((phi_Y + phi_RC)*r*K + (epsilon-1)/epsilon*alpha*wphi_rphi)/r;
phi_w     = (wphi_rphi - r * phi_r)/w;
phi_K     = phi_r;
phi_L     = w * phi_w * nu/L;
phi_beta  = -((p*theta_n + (1-theta_n)*mu_1_n - psi*theta_n^(eta))*phi_F + (1-lambda)*mu_2_n*phi_X ...
              + (p*theta_f + (1-theta_f)*mu_1_f - psi_f*theta_f^(eta_f))*phi_F_f + (1-lambda_f)*mu_2_f*phi_X_f...
              - 1/beta*phi_K)/beta;

Mutil   = C - varphi * L^(1+nu)/(1+nu);

resid_phi_RC    = phi_RC * Mutil - gamma*beta*(1-beta)*phi_beta - gamma*(theta_o*F_o*p - I_o - psi*theta_o^(eta)*F_o);


